<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DetalleSolicitud extends Model 
{

    protected $table = 'detalle_solicitudes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('campo_solicitud_id', 'valor_detalle', 'solicitud_id', 'is_null', 'observations');
    protected $visible = array('campo_solicitud_id', 'valor_detalle', 'solicitud_id', 'is_null', 'observations');

    public function solicitud()
    {
        return $this->belongsTo('Solicitud', 'solicitud_id')->withTrashed();
    }

}